/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.client;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiLanguage;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="kiwi", value={Side.CLIENT})
public class AdvancedFontRenderer
extends FontRenderer
implements ISelectiveResourceReloadListener {
    public static final AdvancedFontRenderer INSTANCE = new AdvancedFontRenderer();
    private static final String COLOR_CODE = "0123456789abcdef";
    private static final String FORMATTING_CODE = "klmno";

    @SubscribeEvent
    public static void onLanguageGuiOpening(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (event.getGui() instanceof GuiLanguage && event.getButton() instanceof GuiOptionButton && ((GuiOptionButton)event.getButton()).func_146136_c() == GameSettings.Options.FORCE_UNICODE_FONT) {
            Minecraft mc = Minecraft.func_71410_x();
            INSTANCE.func_78264_a(mc.field_71474_y.field_151455_aw || mc.func_135016_M().func_135042_a());
        }
    }

    public AdvancedFontRenderer() {
        super(Minecraft.func_71410_x().field_71474_y, new ResourceLocation("textures/font/ascii.png"), Minecraft.func_71410_x().field_71446_o, Minecraft.func_71410_x().field_71466_p.func_82883_a());
        if (Minecraft.func_71410_x().field_71474_y.field_74363_ab != null) {
            this.func_78264_a(Minecraft.func_71410_x().func_152349_b());
            this.func_78275_b(Minecraft.func_71410_x().func_135016_M().func_135044_b());
        }
        IReloadableResourceManager manager = (IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
        manager.func_110542_a((IResourceManagerReloadListener)this);
    }

    public void func_78255_a(String text, boolean shadow) {
        for (int i = 0; i < text.length(); ++i) {
            boolean flag;
            char c0 = text.charAt(i);
            if (c0 == '\u00a7' && i + 1 < text.length()) {
                int i1 = "0123456789abcdefklmnorx".indexOf(String.valueOf(text.charAt(i + 1)).toLowerCase(Locale.ROOT).charAt(0));
                if (i1 < 16) {
                    int j1;
                    this.field_78303_s = false;
                    this.field_78302_t = false;
                    this.field_78299_w = false;
                    this.field_78300_v = false;
                    this.field_78301_u = false;
                    if (i1 < 0 || i1 > 15) {
                        i1 = 15;
                    }
                    if (shadow) {
                        i1 += 16;
                    }
                    this.field_78304_r = j1 = this.field_78285_g[i1];
                    this.setColor((float)(j1 >> 16) / 255.0f, (float)(j1 >> 8 & 0xFF) / 255.0f, (float)(j1 & 0xFF) / 255.0f, this.field_78305_q);
                } else if (i1 == 16) {
                    this.field_78303_s = true;
                } else if (i1 == 17) {
                    this.field_78302_t = true;
                } else if (i1 == 18) {
                    this.field_78299_w = true;
                } else if (i1 == 19) {
                    this.field_78300_v = true;
                } else if (i1 == 20) {
                    this.field_78301_u = true;
                } else if (i1 == 21) {
                    this.field_78303_s = false;
                    this.field_78302_t = false;
                    this.field_78299_w = false;
                    this.field_78300_v = false;
                    this.field_78301_u = false;
                    this.setColor(this.field_78291_n, this.field_78292_o, this.field_78306_p, this.field_78305_q);
                } else if (i1 == 22 && i + 7 < text.length()) {
                    if (text.substring(i + 2, i + 8).matches("[0-9a-fA-F]{6}")) {
                        float r = (float)Integer.parseInt(text.substring(i + 2, i + 4), 16) / 255.0f;
                        float g = (float)Integer.parseInt(text.substring(i + 4, i + 6), 16) / 255.0f;
                        float b = (float)Integer.parseInt(text.substring(i + 6, i + 8), 16) / 255.0f;
                        if (shadow) {
                            r /= 3.0f;
                            g /= 3.0f;
                            b /= 3.0f;
                        }
                        this.setColor(r, g, b, this.field_78305_q);
                    }
                    i += 6;
                }
                ++i;
                continue;
            }
            int j = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(c0);
            if (this.field_78303_s && j != -1) {
                char c1;
                int k = this.func_78263_a(c0);
                while (k != this.func_78263_a(c1 = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".charAt(j = this.field_78289_c.nextInt("\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".length())))) {
                }
                c0 = c1;
            }
            float f1 = j == -1 || this.func_82883_a() ? 0.5f : 1.0f;
            boolean bl = flag = (c0 == '\u0000' || j == -1 || this.func_82883_a()) && shadow;
            if (flag) {
                this.field_78295_j -= f1;
                this.field_78296_k -= f1;
            }
            float f = this.func_181559_a(c0, this.field_78301_u);
            if (AdvancedFontRenderer.isSpecialChar(c0)) {
                f = this.func_78263_a(c0);
            }
            if (flag) {
                this.field_78295_j += f1;
                this.field_78296_k += f1;
            }
            if (this.field_78302_t) {
                this.field_78295_j += f1;
                if (flag) {
                    this.field_78295_j -= f1;
                    this.field_78296_k -= f1;
                }
                this.func_181559_a(c0, this.field_78301_u);
                this.field_78295_j -= f1;
                if (flag) {
                    this.field_78295_j += f1;
                    this.field_78296_k += f1;
                }
                f += 1.0f;
            }
            this.doDraw(f);
        }
    }

    protected float func_181559_a(char ch, boolean italic) {
        boolean flag;
        boolean bl = flag = ch == '\uff08' || ch == '\u201c' || ch == '\uff5b' || ch == '\uff3b' || ch == '\u2018';
        if (flag && super.func_78263_a(ch) == 9) {
            flag = false;
        }
        if (flag) {
            this.field_78295_j += 5.0f;
        }
        float f = super.func_181559_a(ch, italic);
        if (flag) {
            this.field_78295_j -= 5.0f;
        }
        return f;
    }

    public int func_78263_a(char character) {
        return AdvancedFontRenderer.isSpecialChar(character) ? 9 : super.func_78263_a(character);
    }

    public static boolean isSpecialChar(char character) {
        return character == '\uff0c' || character == '\uff1b' || character == '\uff1a' || character == '\uff08' || character == '\uff09' || character == '\u201c' || character == '\u201d' || character == '\uff1f' || character == '\uff01' || character == '\uff5b' || character == '\uff5d' || character == '\uff3b' || character == '\uff3d' || character == '\u2018' || character == '\u2019';
    }

    @Nonnull
    public List<String> func_78271_c(String str, int wrapWidth) {
        BreakIterator lineBreakEngine = BreakIterator.getLineInstance(MinecraftForgeClient.getLocale());
        lineBreakEngine.setText(str);
        ArrayList<String> lines = new ArrayList<String>(8);
        String cachedFormat = "";
        char color = '\u0000';
        char format = 'r';
        int start = 0;
        int width = 0;
        boolean boldMode = false;
        String hexColor = "";
        for (int index = 0; index < str.length(); ++index) {
            String result;
            char c = str.charAt(index);
            if (c == '\n') {
                lines.add(cachedFormat + str.substring(start, index));
                start = index + 1;
                width = 0;
                cachedFormat = AdvancedFontRenderer.determineFormat(color, format, hexColor);
                continue;
            }
            if (c == '\u00a7') {
                char f;
                if ((f = Character.toLowerCase(str.charAt(++index))) == 'r' || f == 'R') {
                    color = '\u0000';
                    format = 'r';
                    continue;
                }
                if (f == 'x') {
                    if (index + 7 >= str.length()) continue;
                    color = '\u0000';
                    hexColor = str.substring(index, index + 7);
                    index += 6;
                    format = 'r';
                    continue;
                }
                if (FORMATTING_CODE.indexOf(f) != -1) {
                    format = f;
                    boldMode = f == 'l';
                    continue;
                }
                if (COLOR_CODE.indexOf(f) == -1) continue;
                color = f;
                hexColor = "";
                format = 'r';
                boldMode = false;
                continue;
            }
            width += this.func_78263_a(c);
            if (boldMode) {
                ++width;
            }
            if (width <= wrapWidth) continue;
            int end = lineBreakEngine.preceding(index);
            if (lineBreakEngine.isBoundary(index)) {
                end = Math.max(end, index);
            }
            if (end <= start) {
                result = cachedFormat + str.substring(start, index);
                start = index;
            } else {
                result = cachedFormat + str.substring(start, end);
                index = start = end;
            }
            lines.add(result);
            --index;
            width = 0;
            cachedFormat = AdvancedFontRenderer.determineFormat(color, format, hexColor);
        }
        String lastPiece = str.substring(start);
        if (!lastPiece.isEmpty()) {
            lines.add(cachedFormat + str.substring(start));
        }
        return lines;
    }

    public int func_78256_a(String text) {
        if (text == null) {
            return 0;
        }
        int len = 0;
        boolean bold = false;
        for (int index = 0; index < text.length(); ++index) {
            int width = this.func_78263_a(text.charAt(index));
            if (width < 0) {
                char format;
                if (Character.toLowerCase(format = text.charAt(++index)) == 'l') {
                    bold = true;
                } else if (Character.toLowerCase(format) == 'r') {
                    bold = false;
                } else if (Character.toLowerCase(format) == 'x') {
                    index += 6;
                }
                width = 0;
            }
            len += width;
            if (!bold || width <= 0) continue;
            ++len;
        }
        return len;
    }

    private static String determineFormat(char color, char format, String hexColor) {
        if (format != 'r') {
            if (hexColor.isEmpty()) {
                if (color == '\u0000') {
                    return new String(new char[]{'\u00a7', format});
                }
                return new String(new char[]{'\u00a7', color, '\u00a7', format});
            }
            return "\u00a7" + hexColor + '\u00a7' + format;
        }
        if (hexColor.isEmpty()) {
            return color == '\u0000' ? "" : new String(new char[]{'\u00a7', color});
        }
        return "\u00a7" + hexColor;
    }

    public void onResourceManagerReload(IResourceManager manager, Predicate<IResourceType> predicate) {
        if (predicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
            super.func_110549_a(manager);
        } else if (predicate.test((IResourceType)VanillaResourceType.LANGUAGES)) {
            LanguageManager languageManager = Minecraft.func_71410_x().func_135016_M();
            this.func_78264_a(languageManager.func_135042_a() || Minecraft.func_71410_x().field_71474_y.field_151455_aw);
            this.func_78275_b(languageManager.func_135044_b());
        }
    }
}

